﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Samples.ServiceHosting.StorageClient;
using System.Data.Services.Client;


namespace ProAzureTableStorageClasses
{
   public class ProAzureReaderDataSource
    {
        private ProAzureReaderDataContext dContext;

        public const string ENTITY_SET_NAME = "ProAzureReader";
        public ProAzureReaderDataSource()
        {
            StorageAccountInfo info = StorageAccountInfo.GetDefaultTableStorageAccountFromConfiguration();
            TableStorage.CreateTablesFromModel(typeof(ProAzureReaderDataContext), info);
            dContext = new ProAzureReaderDataContext(info);
            dContext.RetryPolicy = RetryPolicies.RetryN(3, TimeSpan.FromSeconds(1));
            
        }

        public IEnumerable<ProAzureReader> Select()
        {
         var results = from g in dContext.ProAzureReader
                       where g.PartitionKey == DateTime.UtcNow.ToString("MMddyyyy")
                          select g;
            var r = results.ToArray<ProAzureReader>();
            return r;
        }

        public IEnumerable<ProAzureReader> SelectByCity(string city)
        {
         var results = from g in dContext.ProAzureReader
                       where g.PartitionKey == DateTime.UtcNow.ToString("MMddyyyy")
                       && g.City == city
                       select g;
         var r = results.ToArray<ProAzureReader>();
         return r;
        }
        public IEnumerable<ProAzureReader> SelectByState(string state)
        {
         var results = from g in dContext.ProAzureReader
                       where g.PartitionKey == DateTime.UtcNow.ToString("MMddyyyy")
                       && g.State == state
                       select g;
         var r = results.ToArray<ProAzureReader>();
         return r;
        }
        public IEnumerable<ProAzureReader> SelectByCountry(string country)
        {
         var results = from g in dContext.ProAzureReader
                       where g.PartitionKey == DateTime.UtcNow.ToString("MMddyyyy")
                       && g.Country == country
                       select g;
         var r = results.ToArray<ProAzureReader>();
         return r;
        }

        public IEnumerable<ProAzureReader> SelectByPurchaseDate(DateTime purchaseDate)
        {
         var results = from g in dContext.ProAzureReader
                       where g.PurchaseDate.Equals(purchaseDate )
                       select g;
         var r = results.ToArray<ProAzureReader>();
         return r;
        }

        public IEnumerable<ProAzureReader> SelectTopN(int topNumber)
        {
         var results = dContext.ProAzureReader.Take(topNumber);
         var r = results.ToArray<ProAzureReader>();
         return r;
        }

        public void AddProAzureReader(ProAzureReader newItem)
        {
         dContext.AddObject(ENTITY_SET_NAME, newItem);
         dContext.SaveChangesWithRetries(SaveChangesOptions.None);
        }
        public void UpdateFeedback(string PartitionKey, string RowKey, string feedback)
        {
         var results = from g in dContext.ProAzureReader
                          where g.PartitionKey == PartitionKey
                          && g.RowKey == RowKey
                          select g;
            var e = results.FirstOrDefault<ProAzureReader>();
            e.Feedback = feedback;
            dContext.MergeOption = MergeOption.PreserveChanges;
            dContext.UpdateObject(e);
            dContext.SaveChanges();
        }

        public void UpdateUrl(string PartitionKey, string RowKey, string url)
        {
         var results = from g in dContext.ProAzureReader
                       where g.PartitionKey == PartitionKey
                       && g.RowKey == RowKey
                       select g;
         var e = results.FirstOrDefault<ProAzureReader>();
         e.ReaderUrl = url;
         dContext.MergeOption = MergeOption.PreserveChanges;
         dContext.UpdateObject(e);
         dContext.SaveChanges();
         
        }

        public static void CreateTable(StorageAccountInfo accountInfo)
        {
            // dynamically create the tables
            TableStorage.CreateTablesFromModel(typeof(ProAzureReaderDataContext), accountInfo);

            
        }

        public static IEnumerable<string> ListTables(StorageAccountInfo accountInfo)
        {
         TableStorage tableStorage = TableStorage.Create(accountInfo);
         return tableStorage.ListTables();


        }
        public static void DeleteTable(string tableName, StorageAccountInfo accountInfo)
        {
         TableStorage tableStorage = TableStorage.Create(accountInfo);
         tableStorage.DeleteTable(tableName);


        }
    }
}
